#ifndef _HEADERS_CLIENTINFO_H
#define _HEADERS_CLIENTINFO_H
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

struct _ClientInfo{
    bool Authenticated;

    DWORD FileSize;
    DWORD DataCRC;

    char CompanyName[32];
    char CompanyPassword[64];

    char CompanyDB[32];

    char ClientVersion[10];

    HSTMT StatementHandle;

    SQLBasics DBClass;

}; _ClientInfo CI[MaxClients];

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FreeSingleClientInfo(int Client)
{
    CI[Client].DBClass.DBCloseCursor(&CI[Client].StatementHandle);
    CI[Client].DBClass.DBDisconnect();

    CI[Client].StatementHandle = NULL;

    memset(CI[Client].CompanyName, 0, sizeof(CI[Client].CompanyName));
    memset(CI[Client].CompanyPassword, 0, sizeof(CI[Client].CompanyPassword));
    memset(CI[Client].ClientVersion, 0, sizeof(CI[Client].ClientVersion));
    memset(CI[Client].CompanyDB, 0, sizeof(CI[Client].CompanyDB));

    CI[Client].FileSize = 0;
    CI[Client].DataCRC  = 0;

    CI[Client].Authenticated = false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void InitClientInfo(void)
{
    int LocalLoop = 0;
    while(LocalLoop < MaxClients)
    {
        FreeSingleClientInfo(LocalLoop);
        LocalLoop++;
    }
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

